/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations;

import java.util.stream.Stream;
import lib.toma.animations.api.IAnimationLoader;
import lib.toma.animations.api.IAnimationPipeline;
import lib.toma.animations.api.IHandRenderAPI;
import lib.toma.animations.api.IRenderConfig;
import lib.toma.animations.api.IRenderPipeline;
import lib.toma.animations.api.IUtilScreenFactory;
import lib.toma.animations.api.lifecycle.Registries;
import lib.toma.animations.engine.AnimationPipeline;
import lib.toma.animations.engine.MainRenderPipeline;
import lib.toma.animations.engine.Registry;
import lib.toma.animations.engine.RenderConfig;
import lib.toma.animations.engine.TickHandler;
import lib.toma.animations.engine.screen.HandRenderScreen;
import lib.toma.animations.engine.screen.animator.Animator;
import lib.toma.animations.engine.screen.animator.AnimatorScreen;
import lib.toma.animations.engine.serialization.AnimationLoader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class AnimationEngine {
    public static final Marker MARKER = MarkerManager.getMarker((String)"Engine");
    public static final Logger logger = LogManager.getLogger((String)"AnimationLib");
    private static final String ENGINE_VERSION = "1.5.0";
    public int handConfigKey = 329;
    public int animatorKey = 328;
    private final HandRenderAPI handRenderAPI = new HandRenderAPI();
    private final UtilScreenFactory screenFactory = new UtilScreenFactory();
    private final AnimationPipeline pipeline = new AnimationPipeline();
    private final AnimationLoader loader = new AnimationLoader();
    private final MainRenderPipeline renderPipeline = new MainRenderPipeline();
    private final TickHandler tickHandler = new TickHandler();
    private KeyBinding handConfigs;
    private KeyBinding animator;
    private static final AnimationEngine INSTANCE = new AnimationEngine();

    private AnimationEngine() {
    }

    public synchronized void startEngine(boolean enableDeveloperTools) {
        logger.info(MARKER, "Starting animation engine [{} mode]", (Object)(enableDeveloperTools ? "Developer" : "User"));
        logger.info(MARKER, "Engine version {}", (Object)ENGINE_VERSION);
        logger.info(MARKER, "Creating registries");
        this.initRegistries(enableDeveloperTools);
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addListener(this.tickHandler::onGameTick);
        eventBus.addListener(this.tickHandler::onFrameTick);
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)this.loader);
        logger.info(MARKER, "Registered animation resource manager");
        if (enableDeveloperTools) {
            this.devSetup();
        }
        logger.info(MARKER, "Animation engine - READY");
    }

    private void initRegistries(boolean isDevMode) {
        Stream.of(Registries.ANIMATION_TYPES, Registries.ANIMATION_STAGES, Registries.EVENTS).map(iRegistry -> (Registry)iRegistry).forEach(registry -> registry.load(isDevMode));
    }

    private void devSetup() {
        this.handConfigs = this.registerKey("tools.animation.handConfig", this.handConfigKey);
        this.animator = this.registerKey("tools.animation.animator", this.animatorKey);
        logger.info(MARKER, "Key binds registered: {} - handConfigs, {} - animator", (Object)this.handConfigs.getKey().func_197935_d(), (Object)this.animator.getKey().func_197935_d());
        MinecraftForge.EVENT_BUS.addListener(this::handleKeys);
        logger.info(MARKER, "Key listener registered");
        Animator animator = Animator.get();
        this.loader().addLoadingListener(animator::onAnimationsLoaded);
    }

    public IAnimationLoader loader() {
        return this.loader;
    }

    public IHandRenderAPI getHandRenderAPI() {
        return this.handRenderAPI;
    }

    public IUtilScreenFactory getScreenFactory() {
        return this.screenFactory;
    }

    public IAnimationPipeline pipeline() {
        return this.pipeline;
    }

    public IRenderPipeline renderPipeline() {
        return this.renderPipeline;
    }

    private KeyBinding registerKey(String name, int keycode) {
        KeyBinding bind = new KeyBinding(name, keycode, "tools.animation");
        ClientRegistry.registerKeyBinding((KeyBinding)bind);
        return bind;
    }

    private void handleKeys(InputEvent.KeyInputEvent event) {
        IUtilScreenFactory factory = this.getScreenFactory();
        Minecraft mc = Minecraft.func_71410_x();
        if (this.handConfigs.func_151470_d()) {
            mc.func_147108_a((Screen)factory.getHandConfigScreen());
        } else if (this.animator.func_151470_d()) {
            mc.func_147108_a((Screen)factory.getAnimatorScreen());
        }
    }

    public static AnimationEngine get() {
        return INSTANCE;
    }

    private class UtilScreenFactory
    implements IUtilScreenFactory {
        private UtilScreenFactory() {
        }

        @Override
        public HandRenderScreen getHandConfigScreen() {
            HandRenderAPI api = AnimationEngine.this.handRenderAPI;
            return new HandRenderScreen(api.left, api.right, active -> {
                api.dev = active;
            }, api.isDevMode());
        }

        @Override
        public AnimatorScreen getAnimatorScreen() {
            return new AnimatorScreen();
        }
    }

    private static class HandRenderAPI
    implements IHandRenderAPI {
        boolean dev;
        RenderConfig.Mutable right = new RenderConfig.Mutable();
        RenderConfig.Mutable left = new RenderConfig.Mutable();

        private HandRenderAPI() {
        }

        @Override
        public boolean isDevMode() {
            return this.dev;
        }

        @Override
        public IRenderConfig right() {
            return this.right;
        }

        @Override
        public IRenderConfig left() {
            return this.left;
        }
    }
}

